EESchema Schematic File Version 4
EELAYER 30 0
EELAYER END
$Descr A4 11693 8268
encoding utf-8
Sheet 4 6
Title "Polyphonic Resonator in 5U (MU Version)"
Date "2020-10-12"
Rev "1c"
Comp "CC-by-SA-3.0 Martin Jan Köhler / CC-by-SA-3.0 Émilie Gillet"
Comment1 ""
Comment2 "http://mutable-instruments.net/modules/rings/open_source/"
Comment3 "Thanks to Émilie Gillet for inventing and sharing the original Schematics!"
Comment4 "Additional info available at http://synth.martinjankoehler.com"
$EndDescr
Text Notes 1800 850  0    197  ~ 39
Polyphonic Resonator in 5U (MU Version): Inputs
Text HLabel 2275 1450 0    50   Input ~ 0
AREF_-10
$Comp
L Device:R_Small R20
U 1 1 5BA97E1D
P 2450 1450
F 0 "R20" V 2375 1450 50  0000 C CNN
F 1 "120k" V 2525 1450 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2450 1450 50  0001 C CNN
F 3 "~" H 2450 1450 50  0001 C CNN
	1    2450 1450
	0    1    1    0   
$EndComp
$Comp
L Device:R_Small R18
U 1 1 5BA98075
P 3000 1575
F 0 "R18" V 2925 1575 50  0000 C CNN
F 1 "20k" V 3075 1575 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 3000 1575 50  0001 C CNN
F 3 "~" H 3000 1575 50  0001 C CNN
	1    3000 1575
	0    1    1    0   
$EndComp
Text HLabel 3525 1925 2    50   Output ~ 0
BRIGHTNESS_CV
Wire Wire Line
	2550 1450 2625 1450
Connection ~ 2625 1825
Wire Wire Line
	2625 1825 2700 1825
Wire Wire Line
	3300 1925 3400 1925
Connection ~ 3400 1925
Wire Wire Line
	3400 1925 3525 1925
Wire Wire Line
	2900 1575 2625 1575
Wire Wire Line
	3100 1575 3400 1575
Wire Wire Line
	2625 2100 2625 2025
$Comp
L Device:C_Small C26
U 1 1 5BA9945E
P 3000 1300
F 0 "C26" V 2800 1300 50  0000 C CNN
F 1 "10n" V 2875 1300 50  0000 C CNN
F 2 "CustomFootprints:MJK_C_Radial_P5.0mm" H 3000 1300 50  0001 C CNN
F 3 "~" H 3000 1300 50  0001 C CNN
	1    3000 1300
	0    1    1    0   
$EndComp
Wire Wire Line
	3100 1300 3400 1300
Wire Wire Line
	2900 1300 2625 1300
Wire Wire Line
	2625 1300 2625 1450
Connection ~ 2625 1450
Wire Wire Line
	2625 1450 2625 1575
Wire Wire Line
	3400 1300 3400 1575
Connection ~ 2625 1575
Connection ~ 3400 1575
Wire Wire Line
	2625 1575 2625 1825
Wire Wire Line
	3400 1575 3400 1925
$Comp
L Connector:AudioJack2_SwitchT J6_strum9
U 1 1 5BA9BB46
P 2725 4825
F 0 "J6_strum9" H 2925 4575 50  0000 R CNN
F 1 "-5 to +5V" H 2925 5025 50  0001 R CNN
F 2 "CustomFootprints:Amphenol_ACJM_MV_2S" H 2725 4825 50  0001 C CNN
F 3 "~" H 2725 4825 50  0001 C CNN
	1    2725 4825
	1    0    0    1   
$EndComp
$Comp
L power:GND #PWR0166
U 1 1 5BA9BB4C
P 2975 5000
F 0 "#PWR0166" H 2975 4750 50  0001 C CNN
F 1 "GND" H 2980 4827 50  0000 C CNN
F 2 "" H 2975 5000 50  0001 C CNN
F 3 "" H 2975 5000 50  0001 C CNN
	1    2975 5000
	1    0    0    -1  
$EndComp
$Comp
L Device:R_Small R11
U 1 1 5BA9BB5E
P 3425 4825
F 0 "R11" V 3350 4825 50  0000 C CNN
F 1 "100k" V 3500 4825 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 3425 4825 50  0001 C CNN
F 3 "~" H 3425 4825 50  0001 C CNN
	1    3425 4825
	0    1    1    0   
$EndComp
Wire Wire Line
	2925 4925 2975 4925
Wire Wire Line
	2975 4925 2975 5000
Wire Wire Line
	2925 4725 2975 4725
Text HLabel 950  4800 0    50   Input ~ 0
+3V3
$Comp
L power:GND #PWR0174
U 1 1 5BB3FF5F
P 1075 5550
F 0 "#PWR0174" H 1075 5300 50  0001 C CNN
F 1 "GND" H 1080 5377 50  0000 C CNN
F 2 "" H 1075 5550 50  0001 C CNN
F 3 "" H 1075 5550 50  0001 C CNN
	1    1075 5550
	1    0    0    -1  
$EndComp
Wire Wire Line
	950  4800 1075 4800
Wire Wire Line
	1075 5550 1075 5500
$Comp
L Diode:BAT54S D3
U 1 1 5BB56E65
P 1075 5200
F 0 "D3" H 900 5100 50  0000 L CNN
F 1 "BAT54S" H 1200 5100 50  0000 L CNN
F 2 "Package_TO_SOT_SMD:SOT-23" H 1150 5325 50  0001 L CNN
F 3 "https://www.diodes.com/assets/Datasheets/ds11005.pdf" H 955 5200 50  0001 C CNN
	1    1075 5200
	0    -1   -1   0   
$EndComp
Wire Wire Line
	1075 4800 1075 4900
$Comp
L Device:R_Small R52
U 1 1 5BBC2DB2
P 2350 4800
F 0 "R52" V 2425 4850 50  0000 C CNN
F 1 "100k" V 2500 4825 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2350 4800 50  0001 C CNN
F 3 "~" H 2350 4800 50  0001 C CNN
	1    2350 4800
	-1   0    0    1   
$EndComp
Text HLabel 9000 5000 1    50   Input ~ 0
+3V3_A
$Comp
L Amplifier_Operational:MCP6004 U7
U 5 1 5BBFF75D
P 9100 5450
F 0 "U7" H 9100 5300 50  0000 C CNN
F 1 "MCP6004" V 9075 5525 50  0000 C CNN
F 2 "Package_DIP:DIP-14_W7.62mm_Socket_LongPads" H 9050 5550 50  0001 C CNN
F 3 "http://ww1.microchip.com/downloads/en/DeviceDoc/21733j.pdf" H 9150 5650 50  0001 C CNN
	5    9100 5450
	1    0    0    -1  
$EndComp
$Comp
L power:GND #PWR0177
U 1 1 5BC17C04
P 9000 5925
F 0 "#PWR0177" H 9000 5675 50  0001 C CNN
F 1 "GND" H 9005 5752 50  0000 C CNN
F 2 "" H 9000 5925 50  0001 C CNN
F 3 "" H 9000 5925 50  0001 C CNN
	1    9000 5925
	1    0    0    -1  
$EndComp
$Comp
L Device:C_Small C37
U 1 1 5BC24696
P 9225 5500
F 0 "C37" H 9133 5454 50  0000 R CNN
F 1 "100n" H 9133 5545 50  0000 R CNN
F 2 "CustomFootprints:MJK_C_Axial_L3.8mm_D2.6mm_P7.50mm_Horizontal" H 9225 5500 50  0001 C CNN
F 3 "~" H 9225 5500 50  0001 C CNN
	1    9225 5500
	-1   0    0    1   
$EndComp
Wire Wire Line
	9000 5925 9000 5850
Wire Wire Line
	9225 5600 9225 5850
Wire Wire Line
	9225 5850 9000 5850
Connection ~ 9000 5850
Wire Wire Line
	9000 5850 9000 5750
Wire Wire Line
	2925 4825 3150 4825
$Comp
L Connector:AudioJack2_SwitchT J1_brightness1
U 1 1 5FFF9641
P 1400 1825
F 0 "J1_brightness1" H 1600 1575 50  0000 R CNN
F 1 "-8 to +8V" H 1575 2025 50  0000 R CNN
F 2 "CustomFootprints:Amphenol_ACJM_MV_2S" H 1400 1825 50  0001 C CNN
F 3 "~" H 1400 1825 50  0001 C CNN
	1    1400 1825
	1    0    0    1   
$EndComp
$Comp
L power:GND #PWR0188
U 1 1 5FFF964B
P 1700 1925
F 0 "#PWR0188" H 1700 1675 50  0001 C CNN
F 1 "GND" H 1700 1775 50  0000 C CNN
F 2 "" H 1700 1925 50  0001 C CNN
F 3 "" H 1700 1925 50  0001 C CNN
	1    1700 1925
	1    0    0    -1  
$EndComp
$Comp
L Device:R_Small R19
U 1 1 5FFF9655
P 2100 1825
F 0 "R19" V 2025 1825 50  0000 C CNN
F 1 "100k" V 2175 1825 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2100 1825 50  0001 C CNN
F 3 "~" H 2100 1825 50  0001 C CNN
	1    2100 1825
	0    1    1    0   
$EndComp
Wire Wire Line
	1600 1925 1700 1925
Wire Wire Line
	1600 1725 1650 1725
Wire Wire Line
	1600 1825 1875 1825
Wire Wire Line
	3525 4825 3550 4825
Connection ~ 1275 5200
Wire Wire Line
	2975 4475 2975 4725
$Comp
L Device:R_Small R8
U 1 1 6104A167
P 3850 4375
F 0 "R8" V 3775 4375 50  0000 C CNN
F 1 "10k" V 3925 4375 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 3850 4375 50  0001 C CNN
F 3 "~" H 3850 4375 50  0001 C CNN
	1    3850 4375
	1    0    0    -1  
$EndComp
Text HLabel 4000 4550 2    50   Output ~ 0
STRUM
$Comp
L Transistor_BJT:2N3904 Q1
U 1 1 6104A17E
P 3750 4825
F 0 "Q1" H 3940 4871 50  0000 L CNN
F 1 "2N3904" H 3940 4780 50  0000 L CNN
F 2 "Package_TO_SOT_THT:TO-92_Inline_Wide" H 3950 4750 50  0001 L CIN
F 3 "https://www.fairchildsemi.com/datasheets/2N/2N3904.pdf" H 3750 4825 50  0001 L CNN
	1    3750 4825
	1    0    0    -1  
$EndComp
Wire Wire Line
	3850 4550 4000 4550
Wire Wire Line
	3850 4625 3850 4550
Connection ~ 3850 4550
Wire Wire Line
	3850 4550 3850 4475
Wire Wire Line
	3850 5025 3850 5200
Wire Wire Line
	3850 4275 3850 4175
$Comp
L power:GND #PWR0126
U 1 1 6104A192
P 3850 5200
F 0 "#PWR0126" H 3850 4950 50  0001 C CNN
F 1 "GND" H 3855 5027 50  0000 C CNN
F 2 "" H 3850 5200 50  0001 C CNN
F 3 "" H 3850 5200 50  0001 C CNN
	1    3850 5200
	1    0    0    -1  
$EndComp
Text HLabel 3775 4175 0    50   Input ~ 0
+3V3
Wire Wire Line
	3850 4175 3775 4175
$Comp
L Amplifier_Operational:MCP6002-xP U5
U 3 1 6198C69A
P 10250 5525
F 0 "U5" H 10100 5525 50  0000 C CNN
F 1 "MCP6002" V 10225 5475 50  0000 C CNN
F 2 "Package_DIP:DIP-8_W7.62mm_Socket_LongPads" H 10250 5525 50  0001 C CNN
F 3 "http://ww1.microchip.com/downloads/en/DeviceDoc/21733j.pdf" H 10250 5525 50  0001 C CNN
	3    10250 5525
	-1   0    0    -1  
$EndComp
Text HLabel 10350 5025 1    50   Input ~ 0
+3V3_A
Wire Wire Line
	10350 5025 10350 5150
Wire Wire Line
	10575 5425 10575 5150
Wire Wire Line
	10575 5150 10350 5150
Connection ~ 10350 5150
Wire Wire Line
	10350 5150 10350 5225
$Comp
L Device:C_Small C19
U 1 1 61A1456B
P 10575 5525
F 0 "C19" H 10483 5479 50  0000 R CNN
F 1 "100n" H 10483 5570 50  0000 R CNN
F 2 "CustomFootprints:MJK_C_Axial_L3.8mm_D2.6mm_P7.50mm_Horizontal" H 10575 5525 50  0001 C CNN
F 3 "~" H 10575 5525 50  0001 C CNN
	1    10575 5525
	-1   0    0    1   
$EndComp
Wire Wire Line
	10575 5625 10575 5875
Wire Wire Line
	10575 5875 10350 5875
$Comp
L power:GND #PWR0141
U 1 1 61A42995
P 10350 5925
F 0 "#PWR0141" H 10350 5675 50  0001 C CNN
F 1 "GND" H 10355 5752 50  0000 C CNN
F 2 "" H 10350 5925 50  0001 C CNN
F 3 "" H 10350 5925 50  0001 C CNN
	1    10350 5925
	1    0    0    -1  
$EndComp
Wire Wire Line
	10350 5825 10350 5875
Connection ~ 10350 5875
Wire Wire Line
	10350 5875 10350 5925
Wire Wire Line
	9225 5125 9225 5400
Wire Wire Line
	9000 5125 9000 5000
Connection ~ 9000 5125
Wire Wire Line
	9000 5150 9000 5125
Wire Wire Line
	9000 5125 9225 5125
Wire Wire Line
	1975 6025 2200 6025
$Comp
L Device:R_Small R54
U 1 1 5FF81FF9
P 2500 6025
F 0 "R54" V 2425 6025 50  0000 C CNN
F 1 "36k" V 2575 6025 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2500 6025 50  0001 C CNN
F 3 "~" H 2500 6025 50  0001 C CNN
	1    2500 6025
	0    1    1    0   
$EndComp
Wire Wire Line
	1975 5925 2350 5925
Wire Wire Line
	2775 6025 2600 6025
$Comp
L Connector:AudioJack2_SwitchT J8_in2
U 1 1 5FF81FE5
P 1775 6025
F 0 "J8_in2" H 1900 5775 50  0000 R CNN
F 1 "IN2" H 1950 6225 50  0001 R CNN
F 2 "CustomFootprints:Amphenol_ACJM_MV_2S" H 1775 6025 50  0001 C CNN
F 3 "~" H 1775 6025 50  0001 C CNN
	1    1775 6025
	1    0    0    1   
$EndComp
Wire Wire Line
	2025 6125 2025 6200
Wire Wire Line
	1975 6125 2025 6125
$Comp
L power:GND #PWR0117
U 1 1 5FF81FEF
P 2025 6200
F 0 "#PWR0117" H 2025 5950 50  0001 C CNN
F 1 "GND" H 2030 6027 50  0000 C CNN
F 2 "" H 2025 6200 50  0001 C CNN
F 3 "" H 2025 6200 50  0001 C CNN
	1    2025 6200
	1    0    0    -1  
$EndComp
$Comp
L Device:R_Small R51
U 1 1 5F91E2A9
P 2775 6225
F 0 "R51" V 2700 6225 50  0000 C CNN
F 1 "6.8k" V 2850 6225 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2775 6225 50  0001 C CNN
F 3 "~" H 2775 6225 50  0001 C CNN
	1    2775 6225
	1    0    0    -1  
$EndComp
Wire Wire Line
	2775 6125 2775 6025
Wire Wire Line
	2775 6325 2775 6375
$Comp
L power:GND #PWR0132
U 1 1 5F93DB55
P 2775 6375
F 0 "#PWR0132" H 2775 6125 50  0001 C CNN
F 1 "GND" H 2780 6202 50  0000 C CNN
F 2 "" H 2775 6375 50  0001 C CNN
F 3 "" H 2775 6375 50  0001 C CNN
	1    2775 6375
	1    0    0    -1  
$EndComp
Wire Wire Line
	2350 5725 2350 5925
Wire Wire Line
	2350 5200 2350 5525
$Comp
L Device:R_Small R53
U 1 1 5FF82006
P 2350 5625
F 0 "R53" V 2425 5625 50  0000 C CNN
F 1 "1M" V 2275 5625 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2350 5625 50  0001 C CNN
F 3 "~" H 2350 5625 50  0001 C CNN
	1    2350 5625
	-1   0    0    1   
$EndComp
$Comp
L Device:C_Small C49
U 1 1 5F96F51E
P 3150 6225
F 0 "C49" V 3050 6225 50  0000 C CNN
F 1 "220p" V 3250 6225 50  0000 C CNN
F 2 "CustomFootprints:MJK_C_Radial_P5.0mm" H 3150 6225 50  0001 C CNN
F 3 "~" H 3150 6225 50  0001 C CNN
	1    3150 6225
	1    0    0    -1  
$EndComp
$Comp
L power:GND #PWR0133
U 1 1 5F97121A
P 3150 6375
F 0 "#PWR0133" H 3150 6125 50  0001 C CNN
F 1 "GND" H 3155 6202 50  0000 C CNN
F 2 "" H 3150 6375 50  0001 C CNN
F 3 "" H 3150 6375 50  0001 C CNN
	1    3150 6375
	1    0    0    -1  
$EndComp
Wire Wire Line
	3150 6375 3150 6325
Wire Wire Line
	3150 6025 2775 6025
Wire Wire Line
	3150 6125 3150 6025
Connection ~ 2775 6025
$Comp
L Device:C_Small C40
U 1 1 5F9827A7
P 3525 6025
F 0 "C40" V 3425 6025 50  0000 C CNN
F 1 "10u" V 3625 6025 50  0000 C CNN
F 2 "Capacitor_THT:CP_Radial_D6.3mm_P2.50mm" H 3525 6025 50  0001 C CNN
F 3 "~" H 3525 6025 50  0001 C CNN
	1    3525 6025
	0    1    1    0   
$EndComp
Text HLabel 4000 6025 2    50   Output ~ 0
IN2
Text HLabel 4000 6225 2    50   Output ~ 0
IN1
$Comp
L Device:R_Small R27
U 1 1 5F9857FE
P 3800 6350
F 0 "R27" V 3725 6350 50  0000 C CNN
F 1 "36k" V 3875 6350 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 3800 6350 50  0001 C CNN
F 3 "~" H 3800 6350 50  0001 C CNN
	1    3800 6350
	1    0    0    -1  
$EndComp
$Comp
L power:GND #PWR0134
U 1 1 5F986230
P 3800 6450
F 0 "#PWR0134" H 3800 6200 50  0001 C CNN
F 1 "GND" H 3805 6277 50  0000 C CNN
F 2 "" H 3800 6450 50  0001 C CNN
F 3 "" H 3800 6450 50  0001 C CNN
	1    3800 6450
	1    0    0    -1  
$EndComp
Wire Wire Line
	3150 6025 3425 6025
Wire Wire Line
	3625 6025 4000 6025
Connection ~ 3150 6025
Wire Wire Line
	3800 6250 3800 6225
Wire Wire Line
	3800 6225 4000 6225
Wire Wire Line
	2350 4475 2350 4700
Text HLabel 1375 5325 2    50   Output ~ 0
NORMALIZATION_PROBE
Wire Wire Line
	1275 5100 2350 5100
Wire Wire Line
	1275 5200 2350 5200
Wire Wire Line
	2350 4475 2975 4475
Wire Wire Line
	2275 1450 2350 1450
Wire Wire Line
	2200 1825 2625 1825
$Comp
L power:GND #PWR0135
U 1 1 5FDA12A2
P 2625 2100
F 0 "#PWR0135" H 2625 1850 50  0001 C CNN
F 1 "GND" H 2625 1950 50  0000 C CNN
F 2 "" H 2625 2100 50  0001 C CNN
F 3 "" H 2625 2100 50  0001 C CNN
	1    2625 2100
	1    0    0    -1  
$EndComp
Wire Wire Line
	2625 2025 2700 2025
Text HLabel 5875 5550 0    50   Input ~ 0
AREF_-10
$Comp
L Device:R_Small R23
U 1 1 5FDABC56
P 6050 5550
F 0 "R23" V 5975 5550 50  0000 C CNN
F 1 "120k" V 6125 5550 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 6050 5550 50  0001 C CNN
F 3 "~" H 6050 5550 50  0001 C CNN
	1    6050 5550
	0    1    1    0   
$EndComp
$Comp
L Device:R_Small R25
U 1 1 5FDABC60
P 6600 5675
F 0 "R25" V 6525 5675 50  0000 C CNN
F 1 "20k" V 6675 5675 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 6600 5675 50  0001 C CNN
F 3 "~" H 6600 5675 50  0001 C CNN
	1    6600 5675
	0    1    1    0   
$EndComp
$Comp
L Amplifier_Operational:MCP6004 U7
U 4 1 5FDABC6A
P 6600 6025
F 0 "U7" H 6575 6025 50  0000 C CNN
F 1 "MCP6004" H 6600 6250 50  0000 C CNN
F 2 "Package_DIP:DIP-14_W7.62mm_Socket_LongPads" H 6550 6125 50  0001 C CNN
F 3 "http://ww1.microchip.com/downloads/en/DeviceDoc/21733j.pdf" H 6650 6225 50  0001 C CNN
	4    6600 6025
	1    0    0    1   
$EndComp
Text HLabel 7125 6025 2    50   Output ~ 0
DAMP_CV
Wire Wire Line
	6150 5550 6225 5550
Connection ~ 6225 5925
Wire Wire Line
	6225 5925 6300 5925
Wire Wire Line
	6900 6025 7000 6025
Connection ~ 7000 6025
Wire Wire Line
	7000 6025 7125 6025
Wire Wire Line
	6500 5675 6225 5675
Wire Wire Line
	6700 5675 7000 5675
Wire Wire Line
	6225 6200 6225 6125
$Comp
L Device:C_Small C28
U 1 1 5FDABC7E
P 6600 5400
F 0 "C28" V 6400 5400 50  0000 C CNN
F 1 "10n" V 6475 5400 50  0000 C CNN
F 2 "CustomFootprints:MJK_C_Radial_P5.0mm" H 6600 5400 50  0001 C CNN
F 3 "~" H 6600 5400 50  0001 C CNN
	1    6600 5400
	0    1    1    0   
$EndComp
Wire Wire Line
	6700 5400 7000 5400
Wire Wire Line
	6500 5400 6225 5400
Wire Wire Line
	6225 5400 6225 5550
Connection ~ 6225 5550
Wire Wire Line
	6225 5550 6225 5675
Wire Wire Line
	7000 5400 7000 5675
Connection ~ 6225 5675
Connection ~ 7000 5675
Wire Wire Line
	6225 5675 6225 5925
Wire Wire Line
	7000 5675 7000 6025
$Comp
L Connector:AudioJack2_SwitchT J3_damp3
U 1 1 5FDABC92
P 5000 5925
F 0 "J3_damp3" H 5200 5675 50  0000 R CNN
F 1 "-8 to +8V" H 5175 6125 50  0000 R CNN
F 2 "CustomFootprints:Amphenol_ACJM_MV_2S" H 5000 5925 50  0001 C CNN
F 3 "~" H 5000 5925 50  0001 C CNN
	1    5000 5925
	1    0    0    1   
$EndComp
$Comp
L power:GND #PWR0136
U 1 1 5FDABC9C
P 5300 6025
F 0 "#PWR0136" H 5300 5775 50  0001 C CNN
F 1 "GND" H 5300 5875 50  0000 C CNN
F 2 "" H 5300 6025 50  0001 C CNN
F 3 "" H 5300 6025 50  0001 C CNN
	1    5300 6025
	1    0    0    -1  
$EndComp
$Comp
L Device:R_Small R21
U 1 1 5FDABCA6
P 5850 5925
F 0 "R21" V 5775 5925 50  0000 C CNN
F 1 "100k" V 5925 5925 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 5850 5925 50  0001 C CNN
F 3 "~" H 5850 5925 50  0001 C CNN
	1    5850 5925
	0    1    1    0   
$EndComp
Wire Wire Line
	5200 6025 5300 6025
Wire Wire Line
	5200 5825 5250 5825
Wire Wire Line
	5200 5925 5500 5925
$Comp
L power:GND #PWR0137
U 1 1 5FDABCB3
P 5325 5725
F 0 "#PWR0137" H 5325 5475 50  0001 C CNN
F 1 "GND" H 5325 5575 50  0000 C CNN
F 2 "" H 5325 5725 50  0001 C CNN
F 3 "" H 5325 5725 50  0001 C CNN
	1    5325 5725
	1    0    0    -1  
$EndComp
Wire Wire Line
	5250 5825 5250 5675
Wire Wire Line
	5250 5675 5325 5675
Wire Wire Line
	5325 5675 5325 5725
Wire Wire Line
	5875 5550 5950 5550
Wire Wire Line
	5950 5925 6225 5925
$Comp
L power:GND #PWR0138
U 1 1 5FDABCC2
P 6225 6200
F 0 "#PWR0138" H 6225 5950 50  0001 C CNN
F 1 "GND" H 6225 6050 50  0000 C CNN
F 2 "" H 6225 6200 50  0001 C CNN
F 3 "" H 6225 6200 50  0001 C CNN
	1    6225 6200
	1    0    0    -1  
$EndComp
Wire Wire Line
	6225 6125 6300 6125
$Comp
L Amplifier_Operational:MCP6002-xP U5
U 1 1 5FDBA58C
P 3000 1925
F 0 "U5" H 2950 1925 50  0000 C CNN
F 1 "MCP6002" H 3000 2150 50  0000 C CNN
F 2 "Package_DIP:DIP-8_W7.62mm_Socket_LongPads" H 3000 1925 50  0001 C CNN
F 3 "http://ww1.microchip.com/downloads/en/DeviceDoc/21733j.pdf" H 3000 1925 50  0001 C CNN
	1    3000 1925
	1    0    0    1   
$EndComp
Text HLabel 2250 2750 0    50   Input ~ 0
AREF_-10
$Comp
L Device:R_Small R15
U 1 1 5FDE3FF9
P 2425 2750
F 0 "R15" V 2350 2750 50  0000 C CNN
F 1 "180k" V 2500 2750 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2425 2750 50  0001 C CNN
F 3 "~" H 2425 2750 50  0001 C CNN
	1    2425 2750
	0    1    1    0   
$EndComp
$Comp
L Device:R_Small R13
U 1 1 5FDE4003
P 2975 2875
F 0 "R13" V 2900 2875 50  0000 C CNN
F 1 "47k" V 3050 2875 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2975 2875 50  0001 C CNN
F 3 "~" H 2975 2875 50  0001 C CNN
	1    2975 2875
	0    1    1    0   
$EndComp
Text HLabel 3500 3225 2    50   Output ~ 0
V_OCT_CV
Wire Wire Line
	2525 2750 2600 2750
Connection ~ 2600 3125
Wire Wire Line
	2600 3125 2675 3125
Wire Wire Line
	3275 3225 3375 3225
Connection ~ 3375 3225
Wire Wire Line
	3375 3225 3500 3225
Wire Wire Line
	2875 2875 2600 2875
Wire Wire Line
	3075 2875 3375 2875
Wire Wire Line
	2600 3400 2600 3325
$Comp
L Device:C_Small C14
U 1 1 5FDE4017
P 2975 2600
F 0 "C14" V 2775 2600 50  0000 C CNN
F 1 "2.2n" V 2850 2600 50  0000 C CNN
F 2 "CustomFootprints:MJK_C_Radial_P5.0mm" H 2975 2600 50  0001 C CNN
F 3 "~" H 2975 2600 50  0001 C CNN
	1    2975 2600
	0    1    1    0   
$EndComp
Wire Wire Line
	3075 2600 3375 2600
Wire Wire Line
	2875 2600 2600 2600
Wire Wire Line
	2600 2600 2600 2750
Connection ~ 2600 2750
Wire Wire Line
	2600 2750 2600 2875
Wire Wire Line
	3375 2600 3375 2875
Connection ~ 2600 2875
Connection ~ 3375 2875
Wire Wire Line
	2600 2875 2600 3125
Wire Wire Line
	3375 2875 3375 3225
$Comp
L Connector:AudioJack2_SwitchT J7_voct7
U 1 1 5FDE402B
P 1375 3125
F 0 "J7_voct7" H 1550 2875 50  0000 R CNN
F 1 "-1.5 to 5.5V" H 1550 3325 50  0000 R CNN
F 2 "CustomFootprints:Amphenol_ACJM_MV_2S" H 1375 3125 50  0001 C CNN
F 3 "~" H 1375 3125 50  0001 C CNN
	1    1375 3125
	1    0    0    1   
$EndComp
$Comp
L power:GND #PWR0139
U 1 1 5FDE4035
P 1675 3225
F 0 "#PWR0139" H 1675 2975 50  0001 C CNN
F 1 "GND" H 1675 3075 50  0000 C CNN
F 2 "" H 1675 3225 50  0001 C CNN
F 3 "" H 1675 3225 50  0001 C CNN
	1    1675 3225
	1    0    0    -1  
$EndComp
$Comp
L Device:R_Small R14
U 1 1 5FDE403F
P 2100 3125
F 0 "R14" V 2025 3125 50  0000 C CNN
F 1 "100k" V 2175 3125 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2100 3125 50  0001 C CNN
F 3 "~" H 2100 3125 50  0001 C CNN
	1    2100 3125
	0    1    1    0   
$EndComp
Wire Wire Line
	1575 3225 1675 3225
Wire Wire Line
	1575 3025 1700 3025
Wire Wire Line
	1575 3125 1850 3125
Wire Wire Line
	2250 2750 2325 2750
Wire Wire Line
	2200 3125 2600 3125
$Comp
L power:GND #PWR0140
U 1 1 5FDE405B
P 2600 3400
F 0 "#PWR0140" H 2600 3150 50  0001 C CNN
F 1 "GND" H 2600 3250 50  0000 C CNN
F 2 "" H 2600 3400 50  0001 C CNN
F 3 "" H 2600 3400 50  0001 C CNN
	1    2600 3400
	1    0    0    -1  
$EndComp
Wire Wire Line
	2600 3325 2675 3325
$Comp
L Amplifier_Operational:MCP6002-xP U5
U 2 1 5FDE4066
P 2975 3225
F 0 "U5" H 2925 3225 50  0000 C CNN
F 1 "MCP6002" H 2975 3450 50  0000 C CNN
F 2 "Package_DIP:DIP-8_W7.62mm_Socket_LongPads" H 2975 3225 50  0001 C CNN
F 3 "http://ww1.microchip.com/downloads/en/DeviceDoc/21733j.pdf" H 2975 3225 50  0001 C CNN
	2    2975 3225
	1    0    0    1   
$EndComp
Text HLabel 5900 4175 0    50   Input ~ 0
AREF_-10
$Comp
L Device:R_Small R24
U 1 1 5FE30882
P 6075 4175
F 0 "R24" V 6000 4175 50  0000 C CNN
F 1 "120k" V 6150 4175 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 6075 4175 50  0001 C CNN
F 3 "~" H 6075 4175 50  0001 C CNN
	1    6075 4175
	0    1    1    0   
$EndComp
$Comp
L Device:R_Small R26
U 1 1 5FE3088C
P 6625 4300
F 0 "R26" V 6550 4300 50  0000 C CNN
F 1 "20k" V 6700 4300 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 6625 4300 50  0001 C CNN
F 3 "~" H 6625 4300 50  0001 C CNN
	1    6625 4300
	0    1    1    0   
$EndComp
$Comp
L Amplifier_Operational:MCP6004 U7
U 3 1 5FE30896
P 6625 4650
F 0 "U7" H 6600 4650 50  0000 C CNN
F 1 "MCP6004" H 6625 4875 50  0000 C CNN
F 2 "Package_DIP:DIP-14_W7.62mm_Socket_LongPads" H 6575 4750 50  0001 C CNN
F 3 "http://ww1.microchip.com/downloads/en/DeviceDoc/21733j.pdf" H 6675 4850 50  0001 C CNN
	3    6625 4650
	1    0    0    1   
$EndComp
Text HLabel 7150 4650 2    50   Output ~ 0
FM_CV
Wire Wire Line
	6175 4175 6250 4175
Connection ~ 6250 4550
Wire Wire Line
	6250 4550 6325 4550
Wire Wire Line
	6925 4650 7025 4650
Connection ~ 7025 4650
Wire Wire Line
	7025 4650 7150 4650
Wire Wire Line
	6525 4300 6250 4300
Wire Wire Line
	6725 4300 7025 4300
Wire Wire Line
	6250 4825 6250 4750
$Comp
L Device:C_Small C29
U 1 1 5FE308AA
P 6625 4025
F 0 "C29" V 6425 4025 50  0000 C CNN
F 1 "2.2n" V 6500 4025 50  0000 C CNN
F 2 "CustomFootprints:MJK_C_Radial_P5.0mm" H 6625 4025 50  0001 C CNN
F 3 "~" H 6625 4025 50  0001 C CNN
	1    6625 4025
	0    1    1    0   
$EndComp
Wire Wire Line
	6725 4025 7025 4025
Wire Wire Line
	6525 4025 6250 4025
Wire Wire Line
	6250 4025 6250 4175
Connection ~ 6250 4175
Wire Wire Line
	6250 4175 6250 4300
Wire Wire Line
	7025 4025 7025 4300
Connection ~ 6250 4300
Connection ~ 7025 4300
Wire Wire Line
	6250 4300 6250 4550
Wire Wire Line
	7025 4300 7025 4650
$Comp
L Connector:AudioJack2_SwitchT J2_fm2
U 1 1 5FE308BE
P 5025 4550
F 0 "J2_fm2" H 5225 4300 50  0000 R CNN
F 1 "-8 to +8V" H 5200 4750 50  0000 R CNN
F 2 "CustomFootprints:Amphenol_ACJM_MV_2S" H 5025 4550 50  0001 C CNN
F 3 "~" H 5025 4550 50  0001 C CNN
	1    5025 4550
	1    0    0    1   
$EndComp
$Comp
L power:GND #PWR0143
U 1 1 5FE308C8
P 5325 4650
F 0 "#PWR0143" H 5325 4400 50  0001 C CNN
F 1 "GND" H 5325 4500 50  0000 C CNN
F 2 "" H 5325 4650 50  0001 C CNN
F 3 "" H 5325 4650 50  0001 C CNN
	1    5325 4650
	1    0    0    -1  
$EndComp
$Comp
L Device:R_Small R22
U 1 1 5FE308D2
P 5850 4550
F 0 "R22" V 5775 4550 50  0000 C CNN
F 1 "100k" V 5925 4550 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 5850 4550 50  0001 C CNN
F 3 "~" H 5850 4550 50  0001 C CNN
	1    5850 4550
	0    1    1    0   
$EndComp
Wire Wire Line
	5225 4650 5325 4650
Wire Wire Line
	5900 4175 5975 4175
Wire Wire Line
	5950 4550 6250 4550
$Comp
L power:GND #PWR0144
U 1 1 5FE308EE
P 6250 4825
F 0 "#PWR0144" H 6250 4575 50  0001 C CNN
F 1 "GND" H 6250 4675 50  0000 C CNN
F 2 "" H 6250 4825 50  0001 C CNN
F 3 "" H 6250 4825 50  0001 C CNN
	1    6250 4825
	1    0    0    -1  
$EndComp
Wire Wire Line
	6250 4750 6325 4750
Text HLabel 4825 4050 0    50   Input ~ 0
+3V3_A
$Comp
L Device:R_Small R50
U 1 1 5FE3E06D
P 5050 4050
F 0 "R50" V 4975 4050 50  0000 C CNN
F 1 "3.3M" V 5125 4050 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 5050 4050 50  0001 C CNN
F 3 "~" H 5050 4050 50  0001 C CNN
	1    5050 4050
	0    1    1    0   
$EndComp
Wire Wire Line
	4825 4050 4950 4050
Wire Wire Line
	5325 4050 5325 4450
Wire Wire Line
	5325 4450 5225 4450
Wire Wire Line
	5150 4050 5325 4050
Text HLabel 5875 2850 0    50   Input ~ 0
AREF_-10
$Comp
L Device:R_Small R37
U 1 1 5FE6E42B
P 6050 2850
F 0 "R37" V 5975 2850 50  0000 C CNN
F 1 "120k" V 6125 2850 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 6050 2850 50  0001 C CNN
F 3 "~" H 6050 2850 50  0001 C CNN
	1    6050 2850
	0    1    1    0   
$EndComp
$Comp
L Device:R_Small R32
U 1 1 5FE6E435
P 6600 2975
F 0 "R32" V 6525 2975 50  0000 C CNN
F 1 "20k" V 6675 2975 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 6600 2975 50  0001 C CNN
F 3 "~" H 6600 2975 50  0001 C CNN
	1    6600 2975
	0    1    1    0   
$EndComp
$Comp
L Amplifier_Operational:MCP6004 U7
U 2 1 5FE6E43F
P 6600 3325
F 0 "U7" H 6575 3325 50  0000 C CNN
F 1 "MCP6004" H 6600 3550 50  0000 C CNN
F 2 "Package_DIP:DIP-14_W7.62mm_Socket_LongPads" H 6550 3425 50  0001 C CNN
F 3 "http://ww1.microchip.com/downloads/en/DeviceDoc/21733j.pdf" H 6650 3525 50  0001 C CNN
	2    6600 3325
	1    0    0    1   
$EndComp
Text HLabel 7125 3325 2    50   Output ~ 0
POSITION_CV
Wire Wire Line
	6150 2850 6225 2850
Connection ~ 6225 3225
Wire Wire Line
	6225 3225 6300 3225
Wire Wire Line
	6900 3325 7000 3325
Connection ~ 7000 3325
Wire Wire Line
	7000 3325 7125 3325
Wire Wire Line
	6500 2975 6225 2975
Wire Wire Line
	6700 2975 7000 2975
Wire Wire Line
	6225 3500 6225 3425
$Comp
L Device:C_Small C38
U 1 1 5FE6E453
P 6600 2700
F 0 "C38" V 6400 2700 50  0000 C CNN
F 1 "10n" V 6475 2700 50  0000 C CNN
F 2 "CustomFootprints:MJK_C_Radial_P5.0mm" H 6600 2700 50  0001 C CNN
F 3 "~" H 6600 2700 50  0001 C CNN
	1    6600 2700
	0    1    1    0   
$EndComp
Wire Wire Line
	6700 2700 7000 2700
Wire Wire Line
	6500 2700 6225 2700
Wire Wire Line
	6225 2700 6225 2850
Connection ~ 6225 2850
Wire Wire Line
	6225 2850 6225 2975
Wire Wire Line
	7000 2700 7000 2975
Connection ~ 6225 2975
Connection ~ 7000 2975
Wire Wire Line
	6225 2975 6225 3225
Wire Wire Line
	7000 2975 7000 3325
$Comp
L Connector:AudioJack2_SwitchT J5_position5
U 1 1 5FE6E467
P 5000 3225
F 0 "J5_position5" H 5200 2975 50  0000 R CNN
F 1 "-8 to +8V" H 5175 3425 50  0000 R CNN
F 2 "CustomFootprints:Amphenol_ACJM_MV_2S" H 5000 3225 50  0001 C CNN
F 3 "~" H 5000 3225 50  0001 C CNN
	1    5000 3225
	1    0    0    1   
$EndComp
$Comp
L power:GND #PWR0145
U 1 1 5FE6E471
P 5300 3325
F 0 "#PWR0145" H 5300 3075 50  0001 C CNN
F 1 "GND" H 5300 3175 50  0000 C CNN
F 2 "" H 5300 3325 50  0001 C CNN
F 3 "" H 5300 3325 50  0001 C CNN
	1    5300 3325
	1    0    0    -1  
$EndComp
$Comp
L Device:R_Small R35
U 1 1 5FE6E47B
P 5875 3225
F 0 "R35" V 5800 3225 50  0000 C CNN
F 1 "100k" V 5950 3225 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 5875 3225 50  0001 C CNN
F 3 "~" H 5875 3225 50  0001 C CNN
	1    5875 3225
	0    1    1    0   
$EndComp
Wire Wire Line
	5200 3325 5300 3325
Wire Wire Line
	5200 3225 5500 3225
Wire Wire Line
	5875 2850 5950 2850
Wire Wire Line
	5975 3225 6225 3225
$Comp
L power:GND #PWR0146
U 1 1 5FE6E489
P 6225 3500
F 0 "#PWR0146" H 6225 3250 50  0001 C CNN
F 1 "GND" H 6225 3350 50  0000 C CNN
F 2 "" H 6225 3500 50  0001 C CNN
F 3 "" H 6225 3500 50  0001 C CNN
	1    6225 3500
	1    0    0    -1  
$EndComp
Wire Wire Line
	6225 3425 6300 3425
Wire Wire Line
	5300 3125 5200 3125
Text HLabel 5900 1450 0    50   Input ~ 0
AREF_-10
$Comp
L Device:R_Small R36
U 1 1 5FE7FACC
P 6075 1450
F 0 "R36" V 6000 1450 50  0000 C CNN
F 1 "120k" V 6150 1450 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 6075 1450 50  0001 C CNN
F 3 "~" H 6075 1450 50  0001 C CNN
	1    6075 1450
	0    1    1    0   
$EndComp
$Comp
L Device:R_Small R31
U 1 1 5FE7FAD6
P 6625 1575
F 0 "R31" V 6550 1575 50  0000 C CNN
F 1 "20k" V 6700 1575 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 6625 1575 50  0001 C CNN
F 3 "~" H 6625 1575 50  0001 C CNN
	1    6625 1575
	0    1    1    0   
$EndComp
$Comp
L Amplifier_Operational:MCP6004 U7
U 1 1 5FE7FAE0
P 6625 1925
F 0 "U7" H 6600 1925 50  0000 C CNN
F 1 "MCP6004" H 6625 2150 50  0000 C CNN
F 2 "Package_DIP:DIP-14_W7.62mm_Socket_LongPads" H 6575 2025 50  0001 C CNN
F 3 "http://ww1.microchip.com/downloads/en/DeviceDoc/21733j.pdf" H 6675 2125 50  0001 C CNN
	1    6625 1925
	1    0    0    1   
$EndComp
Text HLabel 7150 1925 2    50   Output ~ 0
GEOMETRY_CV
Wire Wire Line
	6175 1450 6250 1450
Connection ~ 6250 1825
Wire Wire Line
	6250 1825 6325 1825
Wire Wire Line
	6925 1925 7025 1925
Connection ~ 7025 1925
Wire Wire Line
	7025 1925 7150 1925
Wire Wire Line
	6525 1575 6250 1575
Wire Wire Line
	6725 1575 7025 1575
Wire Wire Line
	6250 2100 6250 2025
$Comp
L Device:C_Small C36
U 1 1 5FE7FAF4
P 6625 1300
F 0 "C36" V 6425 1300 50  0000 C CNN
F 1 "10n" V 6500 1300 50  0000 C CNN
F 2 "CustomFootprints:MJK_C_Radial_P5.0mm" H 6625 1300 50  0001 C CNN
F 3 "~" H 6625 1300 50  0001 C CNN
	1    6625 1300
	0    1    1    0   
$EndComp
Wire Wire Line
	6725 1300 7025 1300
Wire Wire Line
	6525 1300 6250 1300
Wire Wire Line
	6250 1300 6250 1450
Connection ~ 6250 1450
Wire Wire Line
	6250 1450 6250 1575
Wire Wire Line
	7025 1300 7025 1575
Connection ~ 6250 1575
Connection ~ 7025 1575
Wire Wire Line
	6250 1575 6250 1825
Wire Wire Line
	7025 1575 7025 1925
$Comp
L Connector:AudioJack2_SwitchT J4_geometry4
U 1 1 5FE7FB08
P 5025 1825
F 0 "J4_geometry4" H 5225 1575 50  0000 R CNN
F 1 "-8 to +8V" H 5200 2025 50  0000 R CNN
F 2 "CustomFootprints:Amphenol_ACJM_MV_2S" H 5025 1825 50  0001 C CNN
F 3 "~" H 5025 1825 50  0001 C CNN
	1    5025 1825
	1    0    0    1   
$EndComp
$Comp
L power:GND #PWR0147
U 1 1 5FE7FB12
P 5325 1925
F 0 "#PWR0147" H 5325 1675 50  0001 C CNN
F 1 "GND" H 5325 1775 50  0000 C CNN
F 2 "" H 5325 1925 50  0001 C CNN
F 3 "" H 5325 1925 50  0001 C CNN
	1    5325 1925
	1    0    0    -1  
$EndComp
$Comp
L Device:R_Small R34
U 1 1 5FE7FB1C
P 5875 1825
F 0 "R34" V 5800 1825 50  0000 C CNN
F 1 "100k" V 5950 1825 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 5875 1825 50  0001 C CNN
F 3 "~" H 5875 1825 50  0001 C CNN
	1    5875 1825
	0    1    1    0   
$EndComp
Wire Wire Line
	5225 1925 5325 1925
Wire Wire Line
	5900 1450 5975 1450
Wire Wire Line
	5975 1825 6250 1825
$Comp
L power:GND #PWR0148
U 1 1 5FE7FB2A
P 6250 2100
F 0 "#PWR0148" H 6250 1850 50  0001 C CNN
F 1 "GND" H 6250 1950 50  0000 C CNN
F 2 "" H 6250 2100 50  0001 C CNN
F 3 "" H 6250 2100 50  0001 C CNN
	1    6250 2100
	1    0    0    -1  
$EndComp
Wire Wire Line
	6250 2025 6325 2025
Wire Wire Line
	5325 1725 5225 1725
NoConn ~ 5325 1725
NoConn ~ 5300 3125
NoConn ~ 1650 1725
Wire Wire Line
	1275 5325 1375 5325
Wire Wire Line
	1700 2775 975  2775
Wire Wire Line
	975  2775 975  3625
Wire Wire Line
	975  3625 1275 3625
Wire Wire Line
	1275 3625 1275 3850
Wire Wire Line
	1700 2775 1700 3025
$Comp
L Device:R_Small R57
U 1 1 5FFA904B
P 1275 3950
F 0 "R57" V 1350 3975 50  0000 C CNN
F 1 "470k" V 1200 3950 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 1275 3950 50  0001 C CNN
F 3 "~" H 1275 3950 50  0001 C CNN
	1    1275 3950
	-1   0    0    1   
$EndComp
Wire Wire Line
	1275 4050 1275 5100
Connection ~ 1275 5100
Wire Wire Line
	1275 5100 1275 5200
Wire Wire Line
	2350 5100 2350 4900
Wire Wire Line
	1275 5200 1275 5325
$Comp
L Device:D_TVS ESD1
U 1 1 5F64EB38
P 1875 2075
F 0 "ESD1" V 1850 2125 50  0000 L CNN
F 1 "Ceradiode" V 1925 2125 50  0000 L CNN
F 2 "Diode_SMD:D_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 1875 2075 50  0001 C CNN
F 3 "~" H 1875 2075 50  0001 C CNN
	1    1875 2075
	0    1    1    0   
$EndComp
$Comp
L power:GND #PWR0155
U 1 1 5F64F4FE
P 1875 2225
F 0 "#PWR0155" H 1875 1975 50  0001 C CNN
F 1 "GND" H 1875 2075 50  0000 C CNN
F 2 "" H 1875 2225 50  0001 C CNN
F 3 "" H 1875 2225 50  0001 C CNN
	1    1875 2225
	1    0    0    -1  
$EndComp
Wire Wire Line
	1875 1925 1875 1825
Connection ~ 1875 1825
Wire Wire Line
	1875 1825 2000 1825
$Comp
L Device:D_TVS ESD2
U 1 1 5F65B0C9
P 1850 3375
F 0 "ESD2" V 1825 3425 50  0000 L CNN
F 1 "Ceradiode" V 1900 3425 50  0000 L CNN
F 2 "Diode_SMD:D_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 1850 3375 50  0001 C CNN
F 3 "~" H 1850 3375 50  0001 C CNN
	1    1850 3375
	0    1    1    0   
$EndComp
$Comp
L power:GND #PWR0156
U 1 1 5F65B0D3
P 1850 3525
F 0 "#PWR0156" H 1850 3275 50  0001 C CNN
F 1 "GND" H 1850 3375 50  0000 C CNN
F 2 "" H 1850 3525 50  0001 C CNN
F 3 "" H 1850 3525 50  0001 C CNN
	1    1850 3525
	1    0    0    -1  
$EndComp
Wire Wire Line
	1850 3225 1850 3125
Connection ~ 1850 3125
Wire Wire Line
	1850 3125 2000 3125
$Comp
L Device:D_TVS ESD8
U 1 1 5F67AB5D
P 5525 2075
F 0 "ESD8" V 5500 2125 50  0000 L CNN
F 1 "Ceradiode" V 5575 2125 50  0000 L CNN
F 2 "Diode_SMD:D_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 5525 2075 50  0001 C CNN
F 3 "~" H 5525 2075 50  0001 C CNN
	1    5525 2075
	0    1    1    0   
$EndComp
$Comp
L power:GND #PWR0157
U 1 1 5F67AB63
P 5525 2225
F 0 "#PWR0157" H 5525 1975 50  0001 C CNN
F 1 "GND" H 5525 2075 50  0000 C CNN
F 2 "" H 5525 2225 50  0001 C CNN
F 3 "" H 5525 2225 50  0001 C CNN
	1    5525 2225
	1    0    0    -1  
$EndComp
Wire Wire Line
	5525 1925 5525 1825
$Comp
L Device:D_TVS ESD5
U 1 1 5F6BA8EA
P 5500 3475
F 0 "ESD5" V 5475 3525 50  0000 L CNN
F 1 "Ceradiode" V 5550 3525 50  0000 L CNN
F 2 "Diode_SMD:D_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 5500 3475 50  0001 C CNN
F 3 "~" H 5500 3475 50  0001 C CNN
	1    5500 3475
	0    1    1    0   
$EndComp
$Comp
L power:GND #PWR0158
U 1 1 5F6BA8F0
P 5500 3625
F 0 "#PWR0158" H 5500 3375 50  0001 C CNN
F 1 "GND" H 5500 3475 50  0000 C CNN
F 2 "" H 5500 3625 50  0001 C CNN
F 3 "" H 5500 3625 50  0001 C CNN
	1    5500 3625
	1    0    0    -1  
$EndComp
Wire Wire Line
	5500 3325 5500 3225
$Comp
L Device:D_TVS ESD6
U 1 1 5F6C5BA5
P 5500 4800
F 0 "ESD6" V 5475 4850 50  0000 L CNN
F 1 "Ceradiode" V 5550 4850 50  0000 L CNN
F 2 "Diode_SMD:D_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 5500 4800 50  0001 C CNN
F 3 "~" H 5500 4800 50  0001 C CNN
	1    5500 4800
	0    1    1    0   
$EndComp
$Comp
L power:GND #PWR0159
U 1 1 5F6C5BAB
P 5500 4950
F 0 "#PWR0159" H 5500 4700 50  0001 C CNN
F 1 "GND" H 5500 4800 50  0000 C CNN
F 2 "" H 5500 4950 50  0001 C CNN
F 3 "" H 5500 4950 50  0001 C CNN
	1    5500 4950
	1    0    0    -1  
$EndComp
Wire Wire Line
	5500 4650 5500 4550
$Comp
L Device:D_TVS ESD7
U 1 1 5F6DB733
P 5500 6175
F 0 "ESD7" V 5475 6225 50  0000 L CNN
F 1 "Ceradiode" V 5550 6225 50  0000 L CNN
F 2 "Diode_SMD:D_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 5500 6175 50  0001 C CNN
F 3 "~" H 5500 6175 50  0001 C CNN
	1    5500 6175
	0    1    1    0   
$EndComp
$Comp
L power:GND #PWR0160
U 1 1 5F6DB739
P 5500 6325
F 0 "#PWR0160" H 5500 6075 50  0001 C CNN
F 1 "GND" H 5500 6175 50  0000 C CNN
F 2 "" H 5500 6325 50  0001 C CNN
F 3 "" H 5500 6325 50  0001 C CNN
	1    5500 6325
	1    0    0    -1  
$EndComp
Wire Wire Line
	5500 6025 5500 5925
Connection ~ 5500 4550
Wire Wire Line
	5500 4550 5750 4550
Wire Wire Line
	5225 4550 5500 4550
Connection ~ 5500 3225
Wire Wire Line
	5500 3225 5775 3225
Connection ~ 5525 1825
Wire Wire Line
	5525 1825 5775 1825
Wire Wire Line
	5225 1825 5525 1825
$Comp
L Device:D_TVS ESD4
U 1 1 5F71DB4D
P 3150 5075
F 0 "ESD4" V 3125 5125 50  0000 L CNN
F 1 "Ceradiode" V 3200 5125 50  0000 L CNN
F 2 "Diode_SMD:D_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 3150 5075 50  0001 C CNN
F 3 "~" H 3150 5075 50  0001 C CNN
	1    3150 5075
	0    1    1    0   
$EndComp
$Comp
L power:GND #PWR0162
U 1 1 5F71DB53
P 3150 5225
F 0 "#PWR0162" H 3150 4975 50  0001 C CNN
F 1 "GND" H 3150 5075 50  0000 C CNN
F 2 "" H 3150 5225 50  0001 C CNN
F 3 "" H 3150 5225 50  0001 C CNN
	1    3150 5225
	1    0    0    -1  
$EndComp
Wire Wire Line
	3150 4925 3150 4825
Connection ~ 3150 4825
Wire Wire Line
	3150 4825 3325 4825
$Comp
L Device:D_TVS ESD3
U 1 1 5F74C19F
P 2200 6275
F 0 "ESD3" V 2175 6325 50  0000 L CNN
F 1 "Ceradiode" V 2250 6325 50  0000 L CNN
F 2 "Diode_SMD:D_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 2200 6275 50  0001 C CNN
F 3 "~" H 2200 6275 50  0001 C CNN
	1    2200 6275
	0    1    1    0   
$EndComp
$Comp
L power:GND #PWR0163
U 1 1 5F74C1A5
P 2200 6425
F 0 "#PWR0163" H 2200 6175 50  0001 C CNN
F 1 "GND" H 2200 6275 50  0000 C CNN
F 2 "" H 2200 6425 50  0001 C CNN
F 3 "" H 2200 6425 50  0001 C CNN
	1    2200 6425
	1    0    0    -1  
$EndComp
Wire Wire Line
	2200 6125 2200 6025
Connection ~ 2200 6025
Wire Wire Line
	2200 6025 2400 6025
Connection ~ 5500 5925
Wire Wire Line
	5500 5925 5750 5925
$EndSCHEMATC
